function xlatedString = getLabel(lang, label)

xlatedString = '???';
switch lang
    case 'en'
        xmlfile = 'english.xml';
    case 'de'
        xmlfile = 'german.xml';
    case 'fr'
        xmlfile = 'french.xml';
end

try
    xDoc = xmlread(xmlfile);
    root = xDoc.getDocumentElement;
    strings = root.getElementsByTagName('string');
    for i=0:strings.getLength - 1
        if strcmp(strings.item(i).getAttribute('id'), label)
            %translate from java string to MATLAB string
            xlatedString = char(strings.item(i).getTextContent);
        end
    end
catch %#ok<CTCH>
    %ignore any read errors and use '???'
end