function halloween_name = getName(data)
% Copyright 2011 The MathWorks, Inc.

% Sort data alphabetically
data.Creatures = sort(data.Creatures);
data.Descriptors = sort(data.Descriptors);
data.Actions = sort(data.Actions);
data.Phrases = sort(data.Phrases);

% Choose a random creature
creatureID = randi(length(data.Creatures));

% Choose one of 3: Descriptor, Action, Descriptor+Action
configID = randi(3);

switch configID
    case 1 % Descriptor
        descriptorID = randi(length(data.Descriptors));
        halloween_name = [data.Descriptors{descriptorID}, ' ', ...
            data.Creatures{creatureID}];
   
    case 2 % Action
        actionID = randi(length(data.Actions));
        halloween_name = [data.Creatures{creatureID}, ' ', ...
            data.Actions{actionID}];
        
        % Additional phrase
        if randi(2) == 1
            rand_phrase = randi(length(data.Phrases));
            halloween_name = [halloween_name, ' ', ...
                data.Phrases{rand_phrase}];
        end
        
    case 3 % Descriptor + Action
        descriptorID = randi(length(data.Descriptors));
        actionID = randi(length(data.Actions));
        halloween_name = [data.Descriptors{descriptorID}, ' ', ...
            data.Creatures{creatureID}, ' ', data.Actions{actionID}];
end
