function halloween(varargin)
% HALLOWEEN   Print out your Halloween name.
%     HALLOWEEN NAME prints a randomly generated Halloween name based on
%     NAME (optional). NAME must be a character array or multiple character
%     arrays.
%
% Example:
%     halloween('Loren')
%     halloween('Sarah Zaranek')
%     halloween Jiro Doke

% Copyright 2011 The MathWorks, Inc.

% Default name
if nargin == 0
    name = 'Nameless';
else
    % Make sure all inputs are character arrays
    cellfun(@(x,y) validateattributes(x, {'char'}, {'row'}, y), ...
        varargin, num2cell(1:nargin));
    % Construct a single name from multiple strings
    name = deblank(sprintf('%s ', varargin{:}));
end

% Special case
[~, ~, ~, ~, ~, sec] = datevec(now);
rng(sec*1000);

if randi(100) > 95  % 5 percent chance of getting this special message.
    fprintf('%s, you are scary enough without a costume!\n', name);
    return;
end

% Set seed based on name and time.
seed = sum(name) + floor(now);
rng(seed);

% Load Halloween data
data = load('HalloweenData');

% Generate Halloween name
halloween_name = getName(data);

% Print out Halloween name
printName(name, halloween_name);