function [Wr,W,rho] = meanWaitTimeMMc(mu, lambda, c)
% MEANWAITTIMEMMC Compute mean waiting time in M/M/c queue configuration
%
%
    
    rho = lambda/(c * mu);
    p0 = 0;
    for k = 0:c-1
        p0 = p0 + ((c*rho)^k/factorial(k));
    end
    pc = ( ((c*rho)^c/factorial(c)) * (1/(1-rho)) );
    Pq  = pc/(p0 + pc);
    
    W = Pq/(c*mu - lambda);
    Wr = W + 1/mu;
end
