%% Plot histogram of wait times
%figure(1);clf;
%subplot(211);
%hist(logsout.get('time4q').Values.Data,20);
%title('4 Q');
%ylabel('Number of customers')
%subplot(212);
%hist(logsout.get('time1q').Values.Data,20);
%title('1 Q');
%xlabel('Wait time')
%ylabel('Number of customers')

%% Plot histogram of "luckiness"
figure(1); clf
idSeq = logsout.get('ID4q').Values.Data + 1; % One-based index
nLuckier = zeros(1, length(idSeq));
nUnLuckier = zeros(1, length(idSeq));
for k = 1:length(idSeq)
    posServed = find(idSeq==k, 1);
    % Number of people who came after a customer who were served earlier
    nLuckier(k) = nnz(idSeq(1:(posServed-1)) > k);
    % Number of people who came before a customer who were served after
    nUnLuckier(k) = nnz(idSeq((posServed+1):end) < k);
end

diffL = nUnLuckier-nLuckier;
mExt = max([max(diffL) max(nLuckier) max(nUnLuckier)]);
hL = hist(nLuckier,0:mExt);
hUL = hist(nUnLuckier,0:mExt);

subplot(313)
diffL = nUnLuckier-nLuckier;
hist(diffL,min(diffL):mExt);
title('Unluckier-Luckier for customer X')
xL = get(gca, 'xlim');

subplot(311)
hist(nLuckier,0:mExt)
title('How many were luckier than customer X?')
set(gca, 'xlim', xL)
set(gca, 'ylim', [0 max([hL hUL])])

subplot(312)
hist(nUnLuckier,0:mExt)
title('How many were unluckier than customer X?')
set(gca, 'xlim', xL)
set(gca, 'ylim', [0 max([hL hUL])])

%% Display statistics
nCustomers = length(nLuckier);
fprintf('Customers who have at least one lucky person get served before them: %d%%\n', round(100*nnz(nLuckier > 0)/nCustomers));
fprintf('Customers who have at least one unlucky person get served after them: %d%%\n', round(100*nnz(nUnLuckier > 0)/nCustomers));
fprintf('Customers who have a net disadvantage: %d%%\n', round(100*nnz((nLuckier - nUnLuckier)>0)/nCustomers));
fprintf('Customers who have a net advantage: %d%%\n', round(100*nnz((nUnLuckier - nLuckier)>0)/nCustomers));
